//	CDialogPrefs.c

#include "Carbon68kGlue.h"
#include "ADFS_LogFile.h"
#include "ADFS_Menus.h"
#include "ADFS_Commands.h"
#include "ADFS_Prefs.h"

#include "CDialogPrefs.h"

/********************************************************/

DGI_ItemRec		gPrf_ItemTable[DPrf_ItemStr_NUMTYPES] = {
	{	kPref_DETOKENIZE_VERB,	
		"You can hold the option key when you start a drag to temporarily "
		"reverse this setting.", teJustLeft, normal	}
};

/********************************************************/
CDialogPrefs		*gCDialogPrefs = NULL;

CDialogPrefs		*ShowPrefsDialog(void)
{
	if (!gCDialogPrefs) {
		gCDialogPrefs = new CDialogPrefs;
		
		if (gCDialogPrefs) {
			if (!gCDialogPrefs->IDialogPrefs()) {
				gCDialogPrefs->Dispose();
				gCDialogPrefs = NULL;
			}
		}
	}

	return gCDialogPrefs;
}

void		HidePrefsDialog(void)
{
	if (gCDialogPrefs) {
		gCDialogPrefs->Dispose();
	}
}

WindowRef	GetPrefsWindow(void)
{
	WindowRef		dialogWindow = NULL;
	
	if (gCDialogPrefs) {
		dialogWindow = gCDialogPrefs->GetWindowRef();
	}
	
	return dialogWindow;
}

/********************************************************/
Boolean		CDialogPrefs::IDialogPrefs(void)
{
	Boolean		success = TRUE;
	
	//	get it hidden, then show
	success = _inherited::IDialog(ADFS_Window_MODAL_DIALOG, 203);
	
	if (success) {		
		GetSmallFontRec(&i_fontRec);

		memcpy(
			i_itemStrTable, gPrf_ItemTable, 
			sizeof(DGI_ItemRec) * DPrf_ItemStr_NUMTYPES);

		SetDlgItemUseStdDraw(kPref_DETOKENIZE_VERB);
	}

	ValueConvert(DGI_ValueConvert_TO, kPref_DETOKENIZE_CHECK);
	ValueConvert(DGI_ValueConvert_TO, kPref_SHOW_PROG_AFTER_POP);
	ValueConvert(DGI_ValueConvert_TO, kPref_ENABLE_LOGGING_CHECK);
	ValueConvert(DGI_ValueConvert_TO, kPref_LOG_UPDATES_CHECK);
	ValueConvert(DGI_ValueConvert_TO, kPref_LOG_MEMORY_CHECK);
	ValueConvert(DGI_ValueConvert_TO, kPref_RED_BACKGROUNDS_CHECK);
	ValueConvert(DGI_ValueConvert_TO, kPref_BW_SCREEN_CHECK);

	if (!USE_LOG_FILE) {
		HideDlogItem(kPref_ENABLE_LOGGING_CHECK);
		HideDlogItem(kPref_LOG_UPDATES_CHECK);
		HideDlogItem(kPref_LOG_MEMORY_CHECK);
	}

	if (success) {
		Rect		windR	= (**gPrefsH).windA[PREF_Wind_PREFS];
		
		if (!EmptyRect(&windR)) {
			MoveWindow(
				GetWindowRef(), 
				windR.left, 
				windR.top, 
				FALSE);
		}

		ShowWindow(GetWindowRef());
	}
	
	if (success) {
		SetModalUp(TRUE);
	}

	return success;
}

void		CDialogPrefs::Dispose(void)
{
	gCDialogPrefs = NULL;

	if ((**gPrefsH).loggingB) {
		ADFS_OpenLogFile();
	} else {
		ADFS_CloseLogFile();
	}

	_inherited::Dispose();

	SetModalUp(FALSE);
}

void	CDialogPrefs::DoKeyDown(EventRecord *event)
{
	_inherited::DoKeyDown(event);
}

void	CDialogPrefs::DoClick(EventRecord *event)
{
	if (FrontWindow() != GetWindowRef()) {
		_inherited::DoClick(event);
	} else {
		DialogRef		theDialog;
		short			itemHit;
		
		DialogSelect(event, &theDialog, &itemHit);

		switch (itemHit) {
		
			case kPref_DETOKENIZE_CHECK: {
				(**gPrefsH).detokenizeB = !(**gPrefsH).detokenizeB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				break;
			}

			case kPref_SHOW_PROG_AFTER_POP: {
				ValueConvert(DGI_ValueConvert_FROM, itemHit);
				SavePrefs();
				break;
			}

			case kPref_ENABLE_LOGGING_CHECK: {
				(**gPrefsH).loggingB = !(**gPrefsH).loggingB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				break;
			}
			
			case kPref_LOG_UPDATES_CHECK: {
				(**gPrefsH).log_updatesB = !(**gPrefsH).log_updatesB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				break;
			}

			case kPref_LOG_MEMORY_CHECK: {
				(**gPrefsH).log_memoryB = !(**gPrefsH).log_memoryB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				break;
			}

			case kPref_RED_BACKGROUNDS_CHECK: {
				(**gPrefsH).redBackgroundB = !(**gPrefsH).redBackgroundB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				InvalAllCWindows();
				break;
			}
			
			case kPref_BW_SCREEN_CHECK: {
				(**gPrefsH).blackAndWhiteB = !(**gPrefsH).blackAndWhiteB;
				SavePrefs();
				ValueConvert(DGI_ValueConvert_TO, itemHit);
				InvalAllCWindows();
				break;
			}
		}
	}
}

void	CDialogPrefs::Move(EventRecord *event)
{
	_inherited::Move(event);
	(**gPrefsH).windA[PREF_Wind_PREFS] = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

void	CDialogPrefs::DialogItemStandardDrawProc(
	DialogItemIndex	itemNo, 
	Rect			*itemRectP)
{
	char				str1[256];
//	unsigned char		*str1P		= (unsigned char *)str1;
	Boolean				drawStringB	= TRUE;
	short				justifyS	= teJustLeft;
	
	Prepare();

	switch (itemNo) {
		
		case kPref_DETOKENIZE_VERB: {
			short	tableIndex = GetItemTableIndex(
				i_itemStrTable, itemNo, DPrf_ItemStr_NUMTYPES);
			
			strcpy(str1, i_itemStrTable[tableIndex].itemStr);
			justifyS = i_itemStrTable[tableIndex].justifyS;
			TextFace(i_itemStrTable[tableIndex].face);
			break;
		}
	}

	if (drawStringB) {
		DrawCStringInRect(str1, itemRectP, justifyS);
	}
}

void		CDialogPrefs::ValueConvert(
	DGI_ValueConvertType	convertType, 
	short					dlgItem)
{
	ControlRef		controlRef = GetDlogItemControl(dlgItem);
//	Boolean			convertFromB = FALSE;
	
	switch (dlgItem) {
		
		case kPref_DETOKENIZE_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).detokenizeB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}
		
		case kPref_SHOW_PROG_AFTER_POP: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, (**gPrefsH).prefProgMenuS);
			} else {
				(**gPrefsH).prefProgMenuS = (ushort)
					GetControlValue(controlRef);
			}
			break;
		}
		
		case kPref_ENABLE_LOGGING_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).loggingB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}
		
		case kPref_LOG_UPDATES_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).log_updatesB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}

		case kPref_LOG_MEMORY_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).log_memoryB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}

		case kPref_RED_BACKGROUNDS_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).redBackgroundB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}
		
		case kPref_BW_SCREEN_CHECK: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 
					(**gPrefsH).blackAndWhiteB);
			} else {
				//	kept up to date
				// (**gPrefsH).detokenizeB = GetControlValue(controlRef);
			}
			break;
		}
	}
}

void		CDialogPrefs::UpdateMenus(void)
{
	EnableCommand(cmdCloseWindow);

	_inherited::UpdateMenus();
}

Boolean		CDialogPrefs::DoCommand(long command)
{
	Boolean			handled = FALSE;
	
	switch (command) {
		
		case cmdCloseWindow: {
			Dispose();
			handled = TRUE;
			break;
		}
		
		default: {
			handled = _inherited::DoCommand(command);
			break;
		}
	}
	
	return handled;
}

ulong		ProgressDelayMenuToTicks(ushort menuID)
{
	ulong	secondsS;
	
	switch (menuID) {

		case kPref_MID_ShowProgAfter_0: {
			secondsS = 0;
			break;
		}
		
		default:
		case kPref_MID_ShowProgAfter_1: {
			secondsS = 1;
			break;
		}

		case kPref_MID_ShowProgAfter_2: {
			secondsS = 2;
			break;
		}

		case kPref_MID_ShowProgAfter_3: {
			secondsS = 3;
			break;
		}

		case kPref_MID_ShowProgAfter_5: {
			secondsS = 5;
			break;
		}

		case kPref_MID_ShowProgAfter_8: {
			secondsS = 8;
			break;
		}

		case kPref_MID_ShowProgAfter_10: {
			secondsS = 10;
			break;
		}

		case kPref_MID_ShowProgAfter_NEVER: {
			secondsS = 1000000;
			break;
		}
	}
	
	return secondsS * 60UL;
}

short				gPrevDepth = 0;
static	void		UpdateDepth(UInt32 newDepth)
{
	if (gPrevDepth != newDepth) {
		gPrevDepth = newDepth;
		
		InvalAllCWindows();
	}
}

void		RestoreOrigDepth(void)
{
	UpdateDepth(gPrevDepth);
}

void		SetPrefDepth(void)
{
	UInt32		newDepth;
	
	if ((**gPrefsH).blackAndWhiteB) {
		newDepth = oneBitMode;
	} else {
		newDepth = gPrevDepth;
	}
	
	UpdateDepth(newDepth);
}

